clear all
set matsize 10000
set maxvar 10000

cd "\IRI data"
	
*** Program to generate summary stats

	import delimited "iri_wm_panel_new.csv"

	merge m:1 iri_key using entries_wide_11.dta
	drop _merge
	
** Create WM post-entry and entry week indicator

	rename wmid* idwm*
	forvalues i=1/19 {
		capture gen wm`i' = (weekid >= week`i')
		capture gen enter`i' = (weekid == week`i')
		capture replace dis`i' = 0 if wm`i' == 0
		}
		egen wm = rowtotal(wm*)
		egen enter = rowtotal(enter*)
		
		encode market, gen(mkt)
	
** Setup
	rename iri_key stores
	xtset stores weekid
	
	* Distance spline
	forvalues s=1/1 {
		forvalues i=1/24 {
			capture gen I_`i'_`s' = (dis`i' <= `s' & dis`i' > 0 )
			}
		egen wm_`s' = rowtotal(I_*_`s')
		drop I*
		}

	forvalues s=3(2)11 {
		local s0 = `s'-2
		forvalues i=1/24 {
			capture gen I_`i'_`s' = (dis`i' <= `s' & dis`i' > `s0' )
			}
		egen wm_`s' = rowtotal(I_*_`s')
		drop I*
		}
	
** Merge in store names
	rename stores iri_key
	merge m:1 iri_key using store_names.dta
	drop if _merge == 2
	drop _merge
	rename iri_key stores
	
	* Merge in chain info
	merge m:1 name using chain.dta
	drop _merge
	
	gen missing_chain = (chainid ==.)
	
	replace firmtype = 3 if firmtype == 4
	encode name, gen(chain)
	replace chain = 0 if missing_chain == 1
	
** Treatment groups
	by stores, sort: egen treat_nwm = max(wm)
	by stores, sort: egen wm0 = min(wm)
	
	gen wm_diff = treat_nwm - wm0
	
** Create variables

	merge m:1 monthid using cpi.dta
	drop _merge
	
	foreach var in carbbev coffee coldcer fzdinent fzpizza hotdog margbutr mayo mustketc peanbutr saltsnck soup spagsauc sugarsub yogurt {
		gen `var'_price = `var' / `var'_vol_sales / cpi * 100
		drop `var' `var'_vol_sales
		}
		
	* Fix outlier
	qui sum fzdinent_price, detail
	replace fzdinent_price = . if fzdinent_price > `r(p99)'

	replace foodrev = foodrev / cpi * 100
	gen logrev = log(foodrev)
	
	compress

keep stores weekid foodrev carbbev_price-yogurt_price enter* wm wm_* chain mkt logrev firmtype treat_nwm
	drop if logrev==.

** Summaries

	* Tables 1 and 2
		tabstat foodrev carbbev_price-yogurt_price, stat(N mean sd p10 p25 median p75 p90) c(s)
		tabstat wm wm_1-wm_11, stat(N mean sd p10 p25 median p75 p90) c(s)
			
	* Table 3
	preserve
	qui sum wm_diff
	forvalues i=1/`r(max)' {
		by stores, sort: gen switch`i' = (wm == `i' & wm[_n-1] == `i'-1)
		gen dis_1_switch`i' = switch`i'*(dis`i' <= 1 & dis`i' > 0)
		gen dis_3_switch`i' = switch`i'*(dis`i' <= 3 & dis`i' > 1)
		gen dis_5_switch`i' = switch`i'*(dis`i' <= 5 & dis`i' > 3)
		gen dis_7_switch`i' = switch`i'*(dis`i' <= 7 & dis`i' > 5)
		gen dis_9_switch`i' = switch`i'*(dis`i' <= 9 & dis`i' > 7)
		gen dis_11_switch`i' = switch`i'*(dis`i' <= 11 & dis`i' > 9)
		}
	foreach var of varlist *switch* {
		by stores, sort: egen max = max(`var')
		drop `var'
		rename max `var'
		}
	duplicates drop stores, force
	
	qui sum wm_diff
	forvalues i=1/`r(max)' {
		tab dis_1_switch`i'
		more
		tab dis_3_switch`i'
		more
		tab dis_5_switch`i'
		more
		tab dis_7_switch`i'
		more
		tab dis_9_switch`i'
		more
		tab dis_11_switch`i'
		more
		tab switch`i'
		more
		}
	restore
	
	* Table 4
	drop dis*
	rename stores iri_key
	merge m:1 iri_key using entries_wide_11.dta
	rename iri_key stores
	drop _merge
	
	forvalues i=1/19 {
		capture replace dis`i'=. if wm`i' == 0
		}
	egen min_dis = rowmin(dis*)
	
	forvalues i=1/19 {
		capture replace dis`i'=. if dis`i'~=min_dis
		}
	
	forvalues i=1/19 {
		capture gen since`i' = weekid - week`i'
		}
	
	local d = 8
	forvalues i=1/19 {
		capture gen dis_1_prepost`i' = 1 if dis`i' <= 1 & dis`i' > 0 & since`i' <= `d' & since`i' > 0
		capture replace dis_1_prepost`i' = 0 if dis`i' <= 1 & dis`i' > 0 & since`i' < 0 & since`i' >= -`d'
		capture gen dis_3_prepost`i' = 1 if dis`i' <= 3 & dis`i' > 1 & since`i' <= `d' & since`i' > 0
		capture replace dis_3_prepost`i' = 0 if dis`i' <= 3 & dis`i' > 1 & since`i' < 0 & since`i' >= -`d'
		capture gen dis_5_prepost`i' = 1 if dis`i' <= 5 & dis`i' > 3 & since`i' <= `d' & since`i' > 0
		capture replace dis_5_prepost`i' = 0 if dis`i' <= 5 & dis`i' > 3 & since`i' < 0 & since`i' >= -`d'
		capture gen dis_7_prepost`i' = 1 if dis`i' <= 7 & dis`i' > 5 & since`i' <= `d' & since`i' > 0
		capture replace dis_7_prepost`i' = 0 if dis`i' <= 7 & dis`i' > 5 & since`i' < 0 & since`i' >= -`d'
		capture gen dis_9_prepost`i' = 1 if dis`i' <= 9 & dis`i' > 7 & since`i' <= `d' & since`i' > 0
		capture replace dis_9_prepost`i' = 0 if dis`i' <= 9 & dis`i' > 7 & since`i' < 0 & since`i' >= -`d'
		capture gen dis_11_prepost`i' = 1 if dis`i' <= 11 & dis`i' > 9 & since`i' <= `d' & since`i' > 0
		capture replace dis_11_prepost`i' = 0 if dis`i' <= 11 & dis`i' > 9 & since`i' < 0 & since`i' >= -`d'
		}
		
	egen dis_1_pre = rowmin(dis_1_prepost*)
	egen dis_1_post = rowmax(dis_1_prepost*)
	drop dis_1_prepost*
	gen dis_1_prepost = 1 if dis_1_post == 1
	replace dis_1_prepost = 0 if dis_1_pre == 0
	
	egen dis_3_pre = rowmin(dis_3_prepost*)
	egen dis_3_post = rowmax(dis_3_prepost*)
	drop dis_3_prepost*
	gen dis_3_prepost = 1 if dis_3_post == 1
	replace dis_3_prepost = 0 if dis_3_pre == 0
	
	egen dis_5_pre = rowmin(dis_5_prepost*)
	egen dis_5_post = rowmax(dis_5_prepost*)
	drop dis_5_prepost*
	gen dis_5_prepost = 1 if dis_5_post == 1
	replace dis_5_prepost = 0 if dis_5_pre == 0
	
	egen dis_7_pre = rowmin(dis_7_prepost*)
	egen dis_7_post = rowmax(dis_7_prepost*)
	drop dis_7_prepost*
	gen dis_7_prepost = 1 if dis_7_post == 1
	replace dis_7_prepost = 0 if dis_7_pre == 0
	
	egen dis_9_pre = rowmin(dis_9_prepost*)
	egen dis_9_post = rowmax(dis_9_prepost*)
	drop dis_9_prepost*
	gen dis_9_prepost = 1 if dis_9_post == 1
	replace dis_9_prepost = 0 if dis_9_pre == 0
	
	egen dis_11_pre = rowmin(dis_11_prepost*)
	egen dis_11_post = rowmax(dis_11_prepost*)
	drop dis_11_prepost*
	gen dis_11_prepost = 1 if dis_11_post == 1
	replace dis_11_prepost = 0 if dis_11_pre == 0
	
	tabstat foodrev carbbev_price-yogurt_price, by(dis_1_prepost) nototal
	tabstat foodrev carbbev_price-yogurt_price, by(dis_3_prepost) nototal
	tabstat foodrev carbbev_price-yogurt_price, by(dis_5_prepost) nototal
	tabstat foodrev carbbev_price-yogurt_price, by(dis_7_prepost) nototal
	tabstat foodrev carbbev_price-yogurt_price, by(dis_9_prepost) nototal
	tabstat foodrev carbbev_price-yogurt_price, by(dis_11_prepost) nototal
	
	foreach var of varlist foodrev carbbev_price-yogurt_price {
		ttest `var', by(dis_1_prepost) unequal
		more
		ttest `var', by(dis_3_prepost) unequal
		more
		ttest `var', by(dis_5_prepost) unequal
		more
		ttest `var', by(dis_7_prepost) unequal
		more
		ttest `var', by(dis_9_prepost) unequal
		more
		ttest `var', by(dis_11_prepost) unequal
		more
		}
		
	forvalues i=3(2)11 {
		gen group`i' = 0 if dis_1_prepost==0 
		replace group`i' = 1 if dis_`i'_prepost==0
		}
		
	foreach var of varlist foodrev carbbev_price-yogurt_price {
		forvalues i=3(2)11 {
			di `var'
			di `i'	
			ttest `var', by(group`i') unequal
			more
			}
		}
	
	* Appendix Table A1
	preserve
	duplicates drop stores, force
	tab firmtype, gen(firmtype_)
	
	rename stores iri_key
	merge m:1 iri_key using "store_demos_cat.dta"
	drop if _merge == 2
	drop _merge
	rename iri_key stores
	
	rename inccymedhh medinc
	rename popcydens density
	rename hhdcy n_hh

	foreach var in medinc density {
		gen log`var' = log(`var')
		norm(log`var'), method(zee)
	}
	gen zee_logincdensity = zee_logmedinc*zee_logdensity
	
	xtile inc = medinc, nq(5)
	xtile dens = density, nq(3)
	
	tabstat wm0 treat_nwm firmtype_* medinc density, stat(N mean sd p10 p25 median p75 p90) c(s)	
	
	restore
		